% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_count.R
\name{intxcount}
\alias{intxcount}
\title{Estimate the CATE model using specified scoring methods}
\usage{
intxcount(
  y,
  trt,
  x.cate,
  x.ps,
  time,
  score.method = c("boosting", "poisson", "twoReg", "contrastReg", "negBin"),
  ps.method = "glm",
  minPS = 0.01,
  maxPS = 0.99,
  initial.predictor.method = "boosting",
  xvar.smooth = NULL,
  tree.depth = 2,
  n.trees.boosting = 200,
  B = 3,
  Kfold = 6,
  plot.gbmperf = TRUE,
  error.maxNR = 0.001,
  max.iterNR = 150,
  tune = c(0.5, 2),
  ...
)
}
\arguments{
\item{y}{Observed outcome; vector of size \code{n} (observations)}

\item{trt}{Treatment received; vector of size \code{n} units with treatment coded as 0/1}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates; dimension \code{n} by \code{p.cate} (covariates in the outcome model)}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates (plus a leading column of 1 for the intercept);
dimension \code{n} by \code{p.ps + 1} (covariates in the propensity score model plus intercept)}

\item{time}{Log-transformed person-years of follow-up; vector of size \code{n}}

\item{score.method}{A vector of one or multiple methods to estimate the CATE score.
Allowed values are: \code{'boosting'}, \code{'poisson'}, \code{'twoReg'}, \code{'contrastReg'},
\code{'negBin'}. Default specifies all 5 methods.}

\item{ps.method}{A character value for the method to estimate the propensity score.
Allowed values include one of:
\code{'glm'} for logistic regression with main effects only (default), or
\code{'lasso'} for a logistic regression with main effects and LASSO penalization on
two-way interactions (added to the model if interactions are not specified in \code{ps.model}).
Relevant only when \code{ps.model} has more than one variable.}

\item{minPS}{A numerical value (in `[0, 1]`) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A number above which estimated propensity scores should be trimmed; scalar}

\item{initial.predictor.method}{A character vector for the method used to get initial
outcome predictions conditional on the covariates in \code{cate.model}
in \code{score.method = 'twoReg'} and \code{'contrastReg'}. Allowed values include
one of \code{'poisson'} (fastest), \code{'boosting'} (default) and \code{'gam'}.}

\item{xvar.smooth}{A vector of characters indicating the name of the variables used as
the smooth terms if \code{initial.predictor.method = 'gam'}. The variables must be selected
from the variables listed in \code{cate.model}.
Default is \code{NULL}, which uses all variables in \code{cate.model}.}

\item{tree.depth}{A positive integer specifying the depth of individual trees in boosting
(usually 2-3). Used only if \code{score.method = 'boosting'} or
if \code{score.method = 'twoReg'} or \code{'contrastReg'} and
\code{initial.predictor.method = 'boosting'}. Default is \code{2}.}

\item{n.trees.boosting}{A positive integer specifying the maximum number of trees in boosting
(usually 100-1000). Used only if \code{score.method = 'boosting'} or
if \code{score.method = 'twoReg'} or \code{'contrastReg'} and
\code{initial.predictor.method = 'boosting'}. Default is \code{200}.}

\item{B}{A positive integer specifying the number of time cross-fitting is repeated in
\code{score.method = 'twoReg'} and \code{'contrastReg'}. Default is \code{3}.}

\item{Kfold}{A positive integer specifying the number of folds (parts) used in cross-fitting
to partition the data in \code{score.method = 'twoReg'} and \code{'contrastReg'}.
Default is \code{6}.}

\item{plot.gbmperf}{A logical value indicating whether to plot the performance measures in
boosting. Used only if \code{score.method = 'boosting'} or if \code{score.method = 'twoReg'}
or \code{'contrastReg'} and \code{initial.predictor.method = 'boosting'}. Default is \code{TRUE}.}

\item{error.maxNR}{A numerical value > 0 indicating the minimum value of the mean absolute
error in Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{0.001}.}

\item{max.iterNR}{A positive integer indicating the maximum number of iterations in the
Newton Raphson algorithm. Used only if \code{score.method = 'contrastReg'}.
Default is \code{150}.}

\item{tune}{A vector of 2 numerical values > 0 specifying tuning parameters for the
Newton Raphson algorithm. \code{tune[1]} is the step size, \code{tune[2]} specifies a
quantity to be added to diagonal of the slope matrix to prevent singularity.
Used only if \code{score.method = 'contrastReg'}. Default is \code{c(0.5, 2)}.}

\item{...}{Additional arguments for \code{gbm()}}
}
\value{
Depending on what score.method is, the outputs is a combination of the following:
          result.boosting: Results of boosting fit and best iteration, for trt = 0 and trt = 1 separately
          result.poisson: Naive Poisson estimator (beta1 - beta0); vector of length \code{p.cate} + 1
          result.twoReg: Two regression estimator (beta1 - beta0); vector of length \code{p.cate} + 1
          result.contrastReg: A list of the contrast regression results with 3 elements:
              $delta.contrastReg: Contrast regression DR estimator; vector of length \code{p.cate} + 1
              $sigma.contrastReg: Variance covariance matrix for delta.contrastReg; matrix of size \code{p.cate} + 1 by \code{p.cate} + 1
              $converge.contrastReg: Indicator that the Newton Raphson algorithm converged for \code{delta_0}; boolean
          result.negBin: Negative binomial estimator (beta1 - beta0); vector of length \code{p.cate} + 1
          best.iter: Largest best iterations for boosting (if used)
          fgam: Formula applied in GAM (if used)
}
\description{
Coefficients of the CATE estimated with boosting, naive Poisson, two regression, contrast regression, negative binomial
}
