% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bar_plot.R
\name{bar_plot}
\alias{bar_plot}
\title{Get a bar plot for flagging percentage overall and stratified by provider sizes}
\usage{
bar_plot(
  flag_df,
  group_num = 4,
  bar_colors = c("#66c2a5", "#fc8d62", "#8da0cb"),
  bar_width = 0.7,
  label_color = "black",
  label_size = 4
)
}
\arguments{
\item{flag_df}{a data frame from \code{test} function containing the flag of each provider.}

\item{group_num}{number of groups into which providers are divided based on their sample sizes. The default is 4.}

\item{bar_colors}{a vector of colors used to fill the bars representing the categories. The default is c("#66c2a5", "#fc8d62", "#8da0cb").}

\item{bar_width}{width of the bars in the bar chart. The default is 0.7.}

\item{label_color}{color of the text labels inside the bars. The default is "black".}

\item{label_size}{size of the text labels inside the bars. The default is 4.}
}
\value{
A ggplot object representing the bar chart of flagging results.
}
\description{
Generate a bar plot for flagging percentage.
}
\details{
This function generates a bar chart to visualize the percentage of flagging results based on provider sizes.
The input data frame \code{test_df} must be the output from package \code{pprof}'s \code{test} function.
Providers are grouped into a specified number of groups (\code{group_num}) based on their sample sizes, where
the number of providers are approximately equal across groups. An additional "overall" group is
included to show the flagging results across all providers.
}
\examples{
data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
fit_linear <- linear_fe(Y = outcome, Z = covar, ProvID = ProvID)
test_linear <- test(fit_linear)
bar_plot(test_linear)

data(ExampleDataBinary)
fit_logis <- logis_fe(Y = ExampleDataBinary$Y,
                      Z = ExampleDataBinary$Z,
                      ProvID = ExampleDataBinary$ProvID, message = FALSE)
test_logis <- test(fit_logis)
bar_plot(test_logis)

}
\seealso{
\code{\link{test.linear_fe}}, \code{\link{test.linear_re}}, \code{\link{test.logis_fe}}
}
