% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_test.R
\name{summarize_tests}
\alias{summarize_tests}
\alias{print.test_summary_list}
\alias{print.test_summary}
\alias{print.test_out_list}
\title{Summarize Test Results}
\usage{
summarize_tests(
  object,
  collapse = c("none", "all_sig", "at_least_one_sig", "at_least_k_sig"),
  at_least_k = 1
)

\method{print}{test_summary_list}(x, digits = 3, ...)

\method{print}{test_summary}(x, digits = 2, ...)

\method{print}{test_out_list}(x, digits = 3, test_long = FALSE, ...)
}
\arguments{
\item{object}{A \code{power4test} object
or the element \code{test_all} in
a \code{power4test} object.}

\item{collapse}{Whether a single
decision (significant vs. not significant)
is made across all tests for a test
that consists of several tests
(e.g., the tests of several parameters).
If \code{"none"}, tests will be summarized
individually. If \code{"all_sig"}, then
the set of tests is considered significant
if all individual tests are significant.
If \code{"at_least_one_sig"}, then the set of
tests is considered significant if
at least one of the tests is significant.
If \code{"at_least_k_sig"}, then the set of
tests is considered significant if
at least \code{k} tests are significant,
\code{k} set by the argument \code{at_least_k}.}

\item{at_least_k}{Used by \code{collapse},
the number of tests required to be
significant for the set of tests to
be considered significant.}

\item{x}{The object to be printed.}

\item{digits}{The numbers of digits
after the decimal when printing
numeric results.}

\item{...}{Optional arguments.
Not used.}

\item{test_long}{If \code{TRUE}, a detailed
report will be printed.}
}
\value{
The function \code{\link[=summarize_tests]{summarize_tests()}} returns
a list of the class \code{test_summary_list}.
Each element contains a summary of a
test stored. The elements are of
the class \code{test_summary}, with
these elements:
\itemize{
\item \code{test_attributes}: The stored
information of a test, for printing.
\item \code{nrep}: The number of datasets
(replications).
\item \code{mean}: The means of numeric
information. For significance
tests, these are the rejection
rates.
\item \code{nvalid}: The number of non-\code{NA}
replications used to compute each
mean.
}

The \code{print} methods returns \code{x} invisibly.
They are called for their side
effects.
}
\description{
Extract and summarize
test results.
}
\details{
The function \code{\link[=summarize_tests]{summarize_tests()}}
is used to extract
information from each test stored
in a \code{power4test} object.

The method \code{print.test_out_list()} is
used to print the content of a list
of test stored in a \code{power4test}
object, with the option to print
just the names of tests.
}
\section{The role of \code{summarize_tests()} and related functions}{
The function \code{\link[=summarize_tests]{summarize_tests()}} and
related print methods are used by
the all-in-one function
\code{\link[=power4test]{power4test()}} and its \code{summary}
method. Users usually do not
call them directly, though
developers can use this function to
develop other functions for power
analysis, or to build their own
workflows to do the power analysis.
}

\examples{

# Specify the model

mod <-
"
m ~ x
y ~ m + x
"

# Specify the population values

es <-
"
y ~ m: l
m ~ x: m
y ~ x: n
"

# Simulated datasets

sim_only <- power4test(nrep = 2,
                       model = mod,
                       pop_es = es,
                       n = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Test the parameters in each dataset

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters)

# Print the summary

summarize_tests(test_out)

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
