% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmMB.R
\name{genMBTree}
\alias{genMBTree}
\title{Generation of the maximally balanced tree}
\usage{
genMBTree(n)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.\cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format,
the number of leaves must be at least 2 since there must be at
least one edge.}
}
\value{
\code{genMBTree} A single tree of class \code{phylo} is returned.
}
\description{
\code{genMBTree} - Generates the rooted binary maximally balanced tree in
\code{phylo} format with the given number of \code{n} leaves.
}
\examples{
genMBTree(n = 6)
}
\references{
\itemize{
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic models.
arXiv:2406.05185, 2024.
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic
models: Supplementary material. https://tinyurl.com/278cwdh8, 2024.
}
}
