% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win_ratio_functions.R
\name{wrtest}
\alias{wrtest}
\title{Two-sample win ratio (net benefit) analysis}
\usage{
wrtest(Y1, Y0, fun = wprod)
}
\arguments{
\item{Y1}{\eqn{K}-variate response data on \eqn{n_1} subjects in treatment (\eqn{n_1\times K} matrix).}

\item{Y0}{\eqn{K}-variate response data on \eqn{n_0} subjects in control (\eqn{n_0\times K} matrix).}

\item{fun}{User-specified win function for pairwise comparison.
It takes two arguments \eqn{y_1}
and \eqn{y_0} (both \eqn{K}-vectors) and returns 1 if \eqn{y_1} wins,
-1 if \eqn{y_0} wins, and 0 if tied. The default is \code{\link{wprod}}
for the product order of multivariate ordinal data.}
}
\value{
An object of class \code{wrtest} with the following components:
\item{theta}{A bivariate vector of win/loss fractions.}
\item{lgwr, lgwr_se, lgwr_pval}{Log-win ratio estimate (\code{log(theta[1]/theta[2])}), standard error, and p-value.}
\item{nb, nb_se, nb_pval}{Net benefit estimate (\code{theta[1]-theta[2]}), standard error, and p-value.}
}
\description{
Estimate and make inference on win ratio (net benefit) comparing a treatment to a control group.
}
\examples{
head(liver)
## compare bivariate ratings by fibrosis stage
## lower score is better
Y1 <- liver[liver$AF, c("R1NASH", "R2NASH")] # advanced
Y0 <- liver[!liver$AF, c("R1NASH", "R2NASH")] # not advanced
obj <- wrtest(Y1, Y0)
obj
}
\references{
Mao, L. (2024). Win ratio for partially ordered data.
\emph{Statistica Sinica}, Under revision.

 Buyse, M. (2010).  Generalized pairwise
 comparisons of prioritized outcomes in the two-sample problem.
 \emph{Statistics in Medicine}, 29, 3245-3257.
}
\seealso{
\code{\link{wprod}}, \code{\link{print.wrtest}}.
}
\keyword{wrtest}
