#' PoolFstat
#'
#' Computing f-Statistics and building admixture graphs based on allele count or Pool-Seq read count data
#'
#' @docType package
#' @name poolfstat
#' @aliases poolfstat-package
#' @exportClass pooldata countdata graph.params fitted.graph fstats pairwisefst 
#' @exportMethod plot heatmap
#' @import graphics
#' @import RcppProgress
#' @importFrom data.table fread fwrite
#' @importFrom utils read.table write.table combn
#' @importFrom methods is new validObject show
#' @importFrom foreach foreach getDoParWorkers %dopar%
#' @importFrom parallel detectCores makeCluster stopCluster
#' @importFrom doParallel registerDoParallel
#' @importFrom stats quantile heatmap dist hclust sd cov reorder as.dist qnorm runif optim
#' @importFrom Rcpp evalCpp
#' @importFrom DiagrammeR grViz
#' @importFrom ape nj dist.nodes
#' @importFrom graphics abline arrows par text
#' @importFrom Ryacas yac
#' @importFrom Matrix rankMatrix
#' @importFrom progress progress_bar
#' @importFrom nnls nnls
#' @useDynLib poolfstat
#' @description Functions for the computation of F-, f- and D-statistics (e.g., Fst, hierarchical F-statistics, Patterson's F2, F3, F3*, F4 and D parameters) in population genomics studies from allele count or Pool-Seq read count data and for the fitting, building and visualization of admixture graphs. The package also includes several utilities to manipulate Pool-Seq data stored in standard format (e.g., such as 'vcf' files or 'rsync' files generated by the the 'PoPoolation' software) and perform conversion to alternative format (as used in the 'BayPass' and 'SelEstim' software). As of version 2.0, the package also includes utilities to manipulate standard allele count data (e.g., stored in TreeMix, BayPass and SelEstim format).
#' @keywords internal
"_PACKAGE"
##NULL
globalVariables(c("nr", "nc")) ##to prevent a note with R CMD check related to interfacing of heatmap with a methods associated to the objects pairwisefst (see out.objects.R)