% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balance.R
\name{plotBalance}
\alias{plotBalance}
\title{Summary Plot of Balance in Covariates}
\usage{
plotBalance(dataBalance, ratioVariances = FALSE, boxplots = TRUE)
}
\arguments{
\item{dataBalance}{the output of \code{\link{balance}}.}

\item{ratioVariances}{Boolean. If \code{TRUE}, the generated plot contains two panels:
one for the standardized differences and one for the ratios of the variances. If \code{FALSE}
(the default), only the standardized differences are represented.}

\item{boxplots}{Boolean. If \code{TRUE} (default), boxplots are added to the plot, to show the
distribution of the standardized differences and ratios of the variances.}
}
\value{
If at least one of the covariates is continuous and \code{ratioVariances=TRUE},
the function generates a plot with two panels: one for the
standardized differences and one for the ratio of the variances (only for the continous variables).
If either all the covariates are categorical/binary or \code{ratioVariances=FALSE} (or both),
only the plot with the standardized differences is generated.
The function also returns a list with the \code{ggplot2} objects corresponding to the generated plot(s).
}
\description{
The function generates a plot summarizing the balance of the covariates.
}
\examples{
#See examples of function 'balance'

}
\seealso{
\code{\link{polymatch}} to generate matched samples and \code{\link{balance}} to compute
the indicators of balance.
}
