% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbi.R
\name{tbi}
\alias{tbi}
\title{T Imbalance Index}
\usage{
tbi(x)
}
\arguments{
\item{x}{(\code{numeric}). A number vector with share of votes or seats. The vector should range from 0 to 1
(if not, the function will automatically make the vector elements sum to one).}
}
\value{
The index ranges from 0 to 1, with 0 being total equilibrium, and 1 total imbalance. When used as an indicator of competitiveness, 0 is the scenario of total competitiveness and 1 is a scenario dominated by one or a few competitors.
}
\description{
`tbi()` calculates T index of inbalance according to the proposition of Taagepera (1979).
}
\examples{

tbi(c(0.2, 0.3, 0.5))

}
\references{
Taagepera, R. (1979). Inequality, Concentration, Imbalance. Political Methodology, 6(3), 275–291. http://www.jstor.org/stable/25791080
}
