% File polarzonoid-package.Rd
\docType{package}

\name{polarzonoid-package}
\alias{polarzonoid-package}
\title{The Polar Zonoid \eqn{Z_n } in \eqn{\mathbb{R}^{2n+1}} }



\description{
In each odd dimension is a special convex body - the polar zonoid - which is generated by trigonometric polynomials.
The package has some applications of the polar zonoid, including the properties of spaces of arcs on the circle and 3x3 rotation matrices.
}


\section{Introduction}{
A \emph{zonoid} is a special type of convex body, see \cite{Bolker}.
Among its many properties, a zonoid is centrally symmetric.
A zonoid has many equivalent definitions,
but in this package a zonoid \eqn{Z} in \eqn{\mathbb{R}^m} is defined by
\eqn{m} real-valued functions \eqn{f_1,f_2,...,f_m} on the circle
\eqn{\mathbb{S}^1}.
These functions are called the \emph{generators} of \eqn{Z}.
When the generators are piecewise constant, one obtains a \emph{zonotope}.
For the precise definition of a zonoid, see the
\href{../doc/polarzonoid-guide.html}{\bold{User Guide}} vignette.

For an integer \eqn{n \ge 0}, we define the
\emph{polar zonoid} \eqn{Z_n } by taking
the generators to be the \eqn{2n{+}1} functions:
\cr
\deqn{\cos(\theta),\sin(\theta), \cos(2\theta),\sin(2\theta),  ... ,\cos(n\theta),\sin(n\theta), 1  ~~~~~~~~ \theta \in [0,2\pi]}

These functions are the standard basis of the
\emph{trignometric polynomials}.
Note that it is convenient for us to put the constant function \eqn{1} \emph{last},
instead of the usual convention of putting it first.
The polar zonoid is a straighforward generalization of
the \emph{polar zonohedron}, see \cite{Chilton and Coxeter}.
In this paper, it is shown that
as the number of sides of the polar zonohedron goes to \eqn{\infty},
the zonohedron converges to \eqn{Z_1 \subseteq \mathbb{R}^3}.

Let \eqn{A_n} be the space of \eqn{n} \emph{or fewer}
disjoint arcs in the circle.
From properties of trigonometric polynomials, it can be
shown that there is a natural homeomorphism
\eqn{A_n    ~~ \rightleftarrows ~~ \partial Z_n}.
For a proof of this, including the definition of the topology
of \eqn{A_n}, see the
\href{../doc/polarzonoid-guide.html}{\bold{User Guide}} vignette.
Among those properties is the fact that a trigonometric polynomial
of degree \eqn{n} has at most \eqn{2n} roots.
It is clear that \eqn{2n}
roots define a set of \eqn{n} disjoint arcs, in two different ways.

In the special case \eqn{n=0}, we define \eqn{A_0} to be
the 2 improper arcs:  the empty arc and the full circle.
We have the inclusions:
\deqn{A_0 \subseteq A_1  \subseteq A_2  \subseteq  ... \subseteq A_n  }

Now the boundary \eqn{\partial Z_n} is trivially homemorphic
to the sphere \eqn{\mathbb{S}^{2n}}.
This is true for \emph{any} convex body in \eqn{\mathbb{R}^{2n+1}}.
Thus we have homeomorphisms:
\deqn{A_n  ~~ \rightleftarrows  ~~  \partial Z_n ~~ \rightleftarrows ~~ \mathbb{S}^{2n} }
where the symbol \eqn{\rightleftarrows} denotes a homeomorphism.
The bulk of the API for this package is the numerical calculation
of these maps.
The maps that go from left to right are straightforward and
implemented for all \eqn{n}.
The inverse maps are much more complicated and,
in this version of the package,
are only implemented for \eqn{n = 0,1,2,3}.
Since \eqn{Z_n } is determined by the single parameter \eqn{n},
there is no need to have an object for \eqn{Z_n} in the package API.
The parameter \eqn{n} can be inferred from the dimension
of vector and matrix function arguments,
or in some cases can be given explicitly.

As a sanity check, note that \eqn{n} arcs have \eqn{2n} endpoints,
so we expect \eqn{A_n} to be a space of dimension \eqn{2n}.
The fact that it is a simple manifold like \eqn{\mathbb{S}^{2n}}
is somewhat surprising.
However, in the simple cases \eqn{n} = 0 and 1,
it is easy to visualize;
see the
\href{../doc/polarzonoid-guide.html}{\bold{User Guide}}
for details.
}

\author{
Glenn Davis <gdavis@gluonics.com>
}

\references{
Bolker, Ethan.
\bold{A Class of Convex Bodies}.
Transactions of the American Mathematical Society.
v. 145.  
Nov. 1969.

B. L. Chilton and H. S. M. Coxeter.
\bold{Polar Zonohedra}.
The American Mathematical Monthly.
Vol 70. No. 9.
pp. 946-951.
1963.
}



\keyword{package}

