% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.trend.R
\name{interval.trend}
\alias{interval.trend}
\title{Calculate pointer years using the interval trend method}
\usage{
interval.trend(data, period = NULL, trend.thresh = 0, 
               IT.thresh = 95, make.plot = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} with tree-ring series (raw or detrended) as columns and years as rows (e.g., output of \code{read.rwl} of package dplR).}

\item{period}{a \code{vector} specifying the start and end year of the analysis. Defaults to the full period covered by the data.}

\item{trend.thresh}{a \code{numeric} specifying the threshold for a percentual growth change to be considered a trend. Defaults to 0.}

\item{IT.thresh}{a \code{numeric} specifying the minimum percentage of trees that should display a negative (or positive) trend for that year to be considered as negative (or positive) pointer year. Defaults to 95.}

\item{make.plot}{a \code{logical} specifying whether a line plot, showing mean annual interval-trend values, should be created. The plot highlights positive and negative pointer years with black triangles pointing up and down, respectively. Defaults to FALSE.}
}
\value{
The function returns a \code{list} containing the following components:
\item{perc.diff}{a \code{matrix} with percentual growth changes for individual tree-ring series}
\item{ITvalues}{a \code{matrix} indicating positive (1), negative (0) and no interval trends (0.5) for individual tree-ring series}
\item{out}{a \code{data.frame} containing the following columns: \code{year} - time stamp, \code{nb.series} - number of series considered, \code{nature} - number indicating whether the year is a positive (1), negative (-1) or no pointer year (0), and \code{IT} - mean overall interval trend}
\item{spec.param}{a \code{data.frame} specifying the arguments used in the calculation}
}
\description{
The function calculates year-to-year growth changes for individual tree-ring series and defines interval trends for (the population of) trees using the pointer interval method according to Schweingruber et al. (1990), which is also extensively described in Jetschke et al. (2019). The minimum percentual growth change and the minimum percentage of trees that should display a negative (or positive) trend for that year to be considered as negative (or positive) pointer year, can be adjusted.
}
\details{
The function calculates year-to-year growth changes. For each tree and year, the interval trend is defined as 1 if a positive change exceeds \code{trend.thresh}, as 0 if a negative change falls below minus \code{trend.thresh} and as 0.5 if the absolute change is below \code{trend.thresh}. \code{trend.thresh} defaults to 0\%. The interval trend for a population is defined as the average interval trend of the individual trees. A year is considered a negative (or positive) pointer year if the percentage of trees showing a decreasing (or increasing) trend exceeds \code{IT.thresh} (defaults to 95\%). Hence, in case of a negative pointer year the mean overall interval trend falls below 1 - \code{IT.thresh}, for a positive pointer year the mean overall interval trend exceeds \code{IT.thresh}.
}
\examples{
## Calculate pointer years using interval.trend
## for a specified period and create a plot
data(s033)
IT <- interval.trend(s033, period = c(1950,2010), make.plot = TRUE)

## Calculate pointer years as years with at least 90\% of the trees
## showing a positive/negative interval trend
data(s033)
IT <- interval.trend(s033, IT.thresh = 90)
IT$out[which(IT$out$nature == 1),"year"]
IT$out[which(IT$out$nature == -1),"year"]

}
\references{
Jetschke, G., van der Maaten, E. and van der Maaten-Theunissen, M. (2019) Towards the extremes: a critical analysis of pointer year detection methods. \emph{Dendrochronologia} 53: 55-62.

Schweingruber, F.H., Eckstein, D., Serre-Bachet, F. and Bräker, O.U. (1990) Identification, presentation and interpretation of event years and pointer years in dendrochronology. \emph{Dendrochronologia} 8: 9-38.
}
\author{
Marieke van der Maaten-Theunissen, Ernst van der Maaten and Gottfried Jetschke.
}
