% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_rhs_data_funs.R
\name{ind_rhs_calc_nm}
\alias{ind_rhs_calc_nm}
\title{Generate individual Right-hand side data (NONMEM)}
\usage{
ind_rhs_calc_nm(
  rhs,
  inputs,
  group,
  est_parms = NULL,
  nm_res_file = NULL,
  nm_phi_file = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}.}

\item{group}{(string) Name of column in \emph{inputs} dataframe defining groups/individuals.}

\item{est_parms}{(dataframe; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_nm} function. For optionality, see \strong{Details}.}

\item{nm_res_file}{(string; semi-optional) (path)/name of the results file of a NONMEM run, must include file extension, e.g., “.res”. For optionality, see \strong{Details}.}

\item{nm_phi_file}{(string; semi-optional) (path)/name of the phi file of a NONMEM run, must include file extension “.phi”. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
Dataframe with columns for the inputs and the combined right-hand side data.
}
\description{
This functions allows to generate right-hand side data for multiple individuals with individual parameter sets, i.e.,
combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{nm_res_file} and \emph{nm_phi_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\author{
Dominic Bräm
}
\keyword{internal}
