% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posi.R
\name{debias_plsmm}
\alias{debias_plsmm}
\title{Post-selection inference for PLSMM}
\usage{
debias_plsmm(x, y, series, plsmm_output, a = 1, Z = NULL)
}
\arguments{
\item{x}{A matrix of predictor variables.}

\item{y}{A continuous vector of response variable.}

\item{series}{A variable representing different series or groups in the data modeled as a random intercept.}

\item{plsmm_output}{Output object obtained from the \code{\link{plsmm_lasso}} function.}

\item{a}{A scalar that adjusts the variance of the random intercept \eqn{\phi} by \eqn{a \times \sigma_{\phi}}, default is 1.}

\item{Z}{(Optional) Pre-computed correction score matrix. If provided, it will be used directly for debiasing.}
}
\value{
A data frame containing debiased coefficients, standard errors, confidence intervals, and p-values.
}
\description{
This function debias the lasso coefficients estimated from the \code{\link{plsmm_lasso}} function
and computes p-values.
}
\details{
The original data is decorrelated, and a correction score matrix is computed. The correction scores are a measure of correlation between the predictors in the data.
The debiasing process utilizes these scores to compute debiased estimates of the coefficients, along with associated p-values.
}
\examples{

set.seed(123)
data_sim = simulate_group_inter(N = 50, n_mvnorm = 3, grouped = TRUE,
                                timepoints = 3:5, nonpara_inter = TRUE,
                                sample_from = seq(0,52,13),
                                cos = FALSE, A_vec = c(1, 1.5))
sim = data_sim$sim
x = as.matrix(sim[,-1:-3])
y = sim$y
series = sim$series
t = sim$t
bases = create_bases(t)
lambda <- 0.0046
gamma <- 0.00000001
plsmm_output <- plsmm_lasso(x, y, series, t,
  name_group_var = "group", bases$bases,
  gamma = gamma, lambda = lambda, timexgroup = TRUE,
  criterion = "BIC"
)
debias_plsmm(x, y, series, plsmm_output)


}
