% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_to_range.R
\name{rescale_to_range}
\alias{rescale_to_range}
\title{Rescale a numeric vector to a new range}
\usage{
rescale_to_range(x, to = c(0, 1), na.rm = TRUE)
}
\arguments{
\item{x}{Numeric vector. The data to be rescaled.}

\item{to}{Numeric vector of length 2 giving the lower and upper limits of
the target range. Defaults to \code{c(0, 1)}.}

\item{na.rm}{Logical. Should missing values be ignored when computing the
source range? Defaults to \code{TRUE}. Any \code{NA}s in \code{x} are returned unchanged.}
}
\value{
A numeric vector the same length as \code{x}, with values rescaled to lie
within \code{to[1]} and \code{to[2]}. The function preserves the positions of
\code{NA}s.
}
\description{
Linearly transforms the values in \code{x} so they fall within a specified
interval. Useful, for example, when mapping latent-space coordinates to
aesthetic ranges (point sizes, color scales, etc.) in a plot.
}
\details{
If all non-missing values in \code{x} are identical, the function returns the
midpoint of the target range (\code{mean(to)}) for those elements to avoid
division by zero.
}
\examples{
set.seed(123)
x <- rnorm(5)

# Default 0~1 range
rescale_to_range(x)

# Rescale to -1~1
rescale_to_range(x, to = c(-1, 1))

# Preserve NAs but ignore them when determining the range
x_with_na <- c(x, NA, 10)
rescale_to_range(x_with_na, to = c(0, 100))

}
