\name{simulate.blim}
\alias{simulate.blim}
\title{Simulate Responses from Basic Local Independence Models (BLIMs)}
\description{
  Simulates responses from the distribution corresponding to a fitted
  \code{blim} model object.
}
\usage{
\method{simulate}{blim}(object, nsim = 1, seed = NULL, \dots)
}
\arguments{
  \item{object}{an object of class \code{blim}, typically the result of a
    call to \code{\link{blim}}.}
  \item{nsim}{currently not used.}
  \item{seed}{currently not used.}
  \item{\dots}{further arguments passed to or from other methods.
    None are used in this method.}
}
\details{
  Responses are simulated in two steps:  First, a knowledge state is drawn
  with probability \code{P.K}.  Second, responses are generated by applying
  \code{\link{rbinom}} with probabilities computed from the model
  object's \code{beta} and \code{eta} components.
}
\value{
  A named vector of frequencies of response patterns.
}
\seealso{
  \code{\link{blim}}, \code{\link{endm}}.
}
\examples{
data(DoignonFalmagne7)
 
m1 <- blim(DoignonFalmagne7$K, DoignonFalmagne7$N.R)
simulate(m1)

## Parametric bootstrap for the BLIM
disc <- replicate(200, blim(m1$K, simulate(m1))$discrepancy)

hist(disc, col = "lightgray", border = "white", freq = FALSE, breaks = 20,
     main = "BLIM parametric bootstrap", xlim = c(.05, .3))
abline(v = m1$discrepancy, lty = 2)

## Parameter recovery for the SLM
m0 <- list( P.K = getSlmPK( g = rep(.8, 5),
                            K = DoignonFalmagne7$K,
                           Ko = getKFringe(DoignonFalmagne7$K)),
           beta = rep(.1, 5),
            eta = rep(.1, 5),
              K = DoignonFalmagne7$K,
         ntotal = 800)
class(m0) <- c("slm", "blim")

pars <- replicate(20, coef(slm(m0$K, simulate(m0), method = "ML")))
boxplot(t(pars), horizontal = TRUE, las = 1,
        main = "SLM parameter recovery")

## See ?endm for further examples.
}
\keyword{models}
