% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionReporter.R
\name{FunctionReporter}
\alias{FunctionReporter}
\title{Function Interdependency Reporter}
\description{
This reporter looks at the network of interdependencies of its
defined functions. Measures of centrality from graph theory can indicate
which function is most important to a package. Combined with unit test
coverage information---also provided by this reporter--- it can be used
as a powerful tool to prioritize test writing.
}
\details{
\subsection{R6 Method Support:}{
    R6 classes are supported, with their methods treated as functions by the
    reporter.

   \itemize{
      \item{R6 methods will be named like
         \code{<classname>$<methodtype>$<methodname>}, e.g.,
         \code{FunctionReporter$private_methods$extract_nodes}.
      }
      \item{Note that the class name used will be the \strong{name of the
         generator object in the package's namespace}.
      }
      \item{The \code{classname} attribute of the class is \strong{not} used.
         In general, it is not required to be defined or the same as the
         generator object name. This attribute is used primarily for
         S3 dispatch.
      }
   }
}
\subsection{Known Limitations:}{
   \itemize{
       \item{Using non-standard evaluation to refer to things (e.g, dataframe
          column names) that have the same name as a function will trick
          \code{FunctionReporter} into thinking the function was called. This
          can be avoided if you don't use reuse function names for other
          purposes.
       }
       \item{Functions stored as list items and not assigned to the package
          namespace will be invisible to \code{FunctionReporter}.
       }
       \item{Calls to methods of instantiated R6 or reference objects will
          not be recognized. We don't have a reliable way of identifying
          instantiated objects, or identifying their class.
       }
       \item{Reference class methods are not yet supported. They will not be
          identified as nodes by \code{FunctionReporter}.
       }
   }
}
}
\seealso{
Other Network Reporters: 
\code{\link{DependencyReporter}},
\code{\link{InheritanceReporter}}

Other Package Reporters: 
\code{\link{DependencyReporter}},
\code{\link{InheritanceReporter}},
\code{\link{SummaryReporter}}
}
\concept{Network Reporters}
\concept{Package Reporters}
\concept{Reporters}
\section{Super classes}{
\code{\link[pkgnet:AbstractPackageReporter]{pkgnet::AbstractPackageReporter}} -> \code{\link[pkgnet:AbstractGraphReporter]{pkgnet::AbstractGraphReporter}} -> \code{FunctionReporter}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{report_markdown_path}}{(character string) path to R Markdown template for this reporter. Read-only.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FunctionReporter-calculate_default_measures}{\code{FunctionReporter$calculate_default_measures()}}
\item \href{#method-FunctionReporter-clone}{\code{FunctionReporter$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractPackageReporter" data-id="set_package"><a href='../../pkgnet/html/AbstractPackageReporter.html#method-AbstractPackageReporter-set_package'><code>pkgnet::AbstractPackageReporter$set_package()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pkgnet" data-topic="AbstractGraphReporter" data-id="get_summary_view"><a href='../../pkgnet/html/AbstractGraphReporter.html#method-AbstractGraphReporter-get_summary_view'><code>pkgnet::AbstractGraphReporter$get_summary_view()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionReporter-calculate_default_measures"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionReporter-calculate_default_measures}{}}}
\subsection{Method \code{calculate_default_measures()}}{
Calculates the default node and network measures for this reporter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionReporter$calculate_default_measures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FunctionReporter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FunctionReporter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FunctionReporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
