% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_pi_ratings.R
\name{calculate_pi_ratings}
\alias{calculate_pi_ratings}
\title{Calculate Pi Ratings}
\usage{
calculate_pi_ratings(teams, outcomes, lambda, gamma, b, c, return_e)
}
\arguments{
\item{teams}{an (n x 2) character matrix,
contains unique names for the respective home and away teams in n
subsequent matches}

\item{outcomes}{an (n x 2) numeric matrix,
contains the points that the respective home and away teams scored in n
subsequent matches}

\item{lambda}{a constant, the learning rate for performance from
recent matches, default value: 0.035}

\item{gamma}{a constant, the learning rate for performance from
home to away and vice versa, default value: 0.7}

\item{b}{a constant, logarithmic base, default value: 10}

\item{c}{a constant, default value: 3}

\item{return_e}{a boolean variable, conditions the function
to return either the mean squared error when return_e = TRUE,
or the pi ratings when return_e = FALSE, default value: FALSE}
}
\value{
either an (n x 2) matrix containing the pi ratings for the teams in
the n input matches or the mean squared error for the specific parameter
setting, conditional on boolean parameter return_e being FALSE or TRUE
}
\description{
This function calculates dynamic performance ratings
called "pi ratings" for sport teams in competitive matches.
The pi rating system was developed by Constantinou and Fenton (2013)
<doi:10.1515/jqas-2012-0036>
}
\examples{
# toy example
teams <- matrix(c("team A", "team B", "team B", "team A"), nrow = 2)
outcomes <- matrix(c(1, 3, 2, 1), nrow = 2)
calculate_pi_ratings(teams, outcomes)
}
