% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_rename_step}
\alias{pipe_rename_step}
\title{Rename step}
\usage{
pipe_rename_step(pip, from, to)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{from}{\code{string} the name of the step to be renamed.}

\item{to}{\code{string} the new name of the step.}
}
\value{
the \code{Pipeline} object invisibly
}
\description{
Safely rename a step in the pipeline. If new step
name would result in a name clash, an error is given.
}
\examples{
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(data = ~data, x = 1) x + data)
pipe_add(p, "add2", \(x = 1, y = ~add1) x + y)
p

try(pipe_rename_step(p, from = "add1", to = "add2"))

pipe_rename_step(p, from = "add1", to = "first_add")
p
}
