% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_print}
\alias{pipe_print}
\title{Print the pipeline as a table}
\usage{
pipe_print(pip, verbose = FALSE)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{verbose}{\code{logical} if \code{TRUE}, print all columns of the
pipeline, otherwise only the most relevant columns are displayed.}
}
\value{
the \code{Pipeline} object invisibly
}
\description{
Print the pipeline as a table
}
\examples{
p <- pipe_new("pipe", data = 1:2)
p$add("f1", \(x = 1) x)
p$add("f2", \(y = 1) y)
pipe_print(p)
pipe_print(p, verbose = TRUE)

# Also works with standard print function
print(p)
print(p, verbose = TRUE)
}
