% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translink_expected_links_true.R
\name{translink_expected_links_true}
\alias{translink_expected_links_true}
\title{Calculate expected number of true transmission pairs}
\usage{
translink_expected_links_true(
  sensitivity,
  rho,
  M,
  R = NULL,
  assumption = "mtml"
)
}
\arguments{
\item{sensitivity}{scalar or vector giving the sensitivity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}

\item{R}{scalar or vector giving the effective reproductive number of the pathogen (default=NULL)}

\item{assumption}{a character vector indicating which assumptions about transmission and linkage criteria. Default = \code{'mtml'}. Accepted arguments are:
\enumerate{
\item \code{'stsl'} for the single-transmission single-linkage assumption.
\item \code{'mtsl'} for the multiple-transmission single-linkage assumption.
\item \code{'mtml'} for the multiple-transmission multiple-linkage assumption.
}}
}
\value{
scalar or vector giving the expected number of true transmission pairs in the sample
}
\description{
This function calculates the expected number true transmission pairs in a sample of size \code{M}.
Assumptions about transmission and linkage (single or multiple) can be specified.
}
\examples{
translink_expected_links_true(sensitivity=0.99, rho=0.75, M=100, R=1)

}
\seealso{
Other transmission linkage functions: 
\code{\link{translink_expected_links_obs_mtml}()},
\code{\link{translink_expected_links_obs_mtsl}()},
\code{\link{translink_expected_links_obs_stsl}()},
\code{\link{translink_expected_links_obs}()},
\code{\link{translink_expected_links_true_mtml}()},
\code{\link{translink_expected_links_true_mtsl}()},
\code{\link{translink_expected_links_true_stsl}()},
\code{\link{translink_fdr}()},
\code{\link{translink_prob_transmit_mtml}()},
\code{\link{translink_prob_transmit_mtsl}()},
\code{\link{translink_prob_transmit_stsl}()},
\code{\link{translink_prob_transmit}()},
\code{\link{translink_samplesize}()},
\code{\link{translink_tdr}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{transmission linkage functions}
