% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_spec_calc.R
\name{sens_spec_calc}
\alias{sens_spec_calc}
\title{Calculate sensitivity and specificity}
\usage{
sens_spec_calc(
  cutoff,
  mut_rate,
  mean_gens_pdf,
  max_link_gens = 1,
  max_gens = NULL,
  max_dist = NULL
)
}
\arguments{
\item{cutoff}{the maximum genetic distance at which to consider cases linked}

\item{mut_rate}{mean number of mutations per generation, assumed to be Poisson distributed}

\item{mean_gens_pdf}{the density distribution of the mean number of generations between cases;
the index of this vector is assumed to be the discrete distance between cases}

\item{max_link_gens}{the maximum generations of separation for linked pairs}

\item{max_gens}{the maximum number of generations to consider, if \code{NULL} (default) value set to the highest
number of generations in mean_gens_pdf with a non-zero probability}

\item{max_dist}{the maximum distance to calculate, if \code{NULL} (default) value set to max_gens * 99.9th percentile
of mut_rate Poisson distribution}
}
\value{
a data frame with the sensitivity and specificity for a particular genetic distance cutoff
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Function to calculate the sensitivity and specificity of a genetic distance cutoff
given an underlying mutation rate and mean number of generations between cases
}
\examples{
# calculate the sensitivity and specificity for a specific genetic distance threshold of 2 mutations
sens_spec_calc(cutoff=2,
               mut_rate=1,
               mean_gens_pdf=c(0.02,0.08,0.15,0.75),
               max_link_gens=1)

# calculate the sensitivity and specificity for a a range of genetic distance thresholds
sens_spec_calc(cutoff=1:10,
               mut_rate=1,
               mean_gens_pdf=c(0.02,0.08,0.15,0.75),
               max_link_gens=1)

}
\seealso{
Other mutrate_functions: 
\code{\link{gen_dists}()},
\code{\link{get_optim_roc}()},
\code{\link{sens_spec_roc}()}
}
\author{
Shirlee Wohl and Justin Lessler
}
\concept{mutrate_functions}
