% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_optim_roc.R
\name{get_optim_roc}
\alias{get_optim_roc}
\title{Find optimal ROC threshold}
\usage{
get_optim_roc(roc)
}
\arguments{
\item{roc}{a dataframe produced by the \code{sens_spec_roc()} function containing the Receiver Operating Characteristic (ROC) curve}
}
\value{
vector containing optimal thresholds of sensitivity and specificity
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function takes the dataframe output of the \code{sens_spec_roc()} function and finds the optimal threshold
of sensitivity and specificity by minimizing the distance to the top left corner of the Receiver Operating Characteristic (ROC) curve
}
\examples{
# ebola-like pathogen
R <- 1.5
mut_rate <- 1

# use simulated generation distributions
data(genDistSim)
mean_gens_pdf <- as.numeric(genDistSim[genDistSim$R == R, -(1:2)])

# get theoretical genetic distance dist based on mutation rate and generation parameters
dists <- as.data.frame(gen_dists(mut_rate = mut_rate,
                                 mean_gens_pdf = mean_gens_pdf,
                                 max_link_gens = 1))

# reshape dataframe for plotting
dists <- reshape2::melt(dists,
                        id.vars = 'dist',
                        variable.name = 'status',
                        value.name = 'prob')

# get sensitivity and specificity using the same paramters
roc_calc <- sens_spec_roc(cutoff = 1:(max(dists$dist)-1),
                          mut_rate = mut_rate,
                          mean_gens_pdf = mean_gens_pdf)

# get the optimal value for the ROC plot
optim_point <- get_optim_roc(roc_calc)

}
\seealso{
Other mutrate_functions: 
\code{\link{gen_dists}()},
\code{\link{sens_spec_calc}()},
\code{\link{sens_spec_roc}()}
}
\author{
Shirlee Wohl, John Giles, and Justin Lessler
}
\concept{mutrate_functions}
