% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-stopbound-post.r
\name{stopbound_post}
\alias{stopbound_post}
\title{The stopping boundaries based on Thall and Simon's criterion}
\usage{
stopbound_post(theta, type, nmax, alpha_e, beta_e, alpha_s, beta_s, delta)
}
\arguments{
\item{theta}{the cutoff probability: typically, \eqn{\theta = [0.95, 0.99]} for superiority, \eqn{\theta = [0.01, 0.05]} for futility.}

\item{type}{type of boundaries: "superiority" or "futility".}

\item{nmax}{the maximum number of patients treated by the experimental drug.}

\item{alpha_e}{the hyperparameter (shape1) of the Beta prior for the experimental drug.}

\item{beta_e}{the hyperparameter (shape2) of the Beta prior for the experimental drug.}

\item{alpha_s}{the hyperparameter (shape1) of the Beta prior for the standard drug.}

\item{beta_s}{the hyperparameter (shape2) of the Beta prior for the standard drug.}

\item{delta}{the minimally acceptable increment of the response rate for the experimental drug compared with the standard drug.
Note: if type = "superiority", then delta is set to 0.}
}
\value{
\item{boundset}{the boundaries set; \eqn{U_n} or \eqn{L_n}}
}
\description{
The stopping boundaries based on Thall and Simon's criterion.
}
\examples{
stopbound_post(0.05, "futility", 40, 0.6, 1.4, 15, 35, 0)
stopbound_post(0.05, "futility", 30, 0.4, 1.6, 10, 40, 0)
stopbound_post(0.95, "superiority", 40, 0.6, 1.4, 15, 35, 0)
}
\references{
Thall, P. F., Simon, R. (1994).
Practical Bayesian guidelines for phase IIB clinical trials.
\emph{Biometrics} \strong{50}: 337-349.

Yin, G. (2012).
\emph{Clinical Trial Design: Bayesian and Frequentist Adaptive Methods.}
New York: Wiley.
}
