% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_group.R
\name{permute_sign}
\alias{permute_sign}
\title{Sign permutation}
\usage{
permute_sign(df, group_col, strata_col = NULL, seed = NULL)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{strata_col}{The name of the column in df that corresponds to the strata, should be NULL for this function}

\item{seed}{An integer seed value}
}
\value{
The inputted data frame with the group column replaced with randomly assigned signs
}
\description{
This function takes a data frame and group and outcome column name as input
and returns the dataframe with the group column replaced with randomly assigned signs
}
\examples{
data <- data.frame(group_label = rep(1, 6), outcome = 1:6)
permute_group(df = data, group_col = "group_label", strata_col = NULL, seed = 42)

}
