% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{neg_log_lik_integrated}
\alias{neg_log_lik_integrated}
\title{Negative marginalized log-likelihood function based on R0 and R}
\usage{
neg_log_lik_integrated(theta, Rvect, n, pi0, alpha0, alpha, beta, ...)
}
\arguments{
\item{theta}{A \code{numeric} value for the paramerer of interest.}

\item{Rvect}{A \code{vector} of observations, i.e. (R1, R2, R3, R4), but R2 and R4 are NOT used.}

\item{n}{A \code{numeric} that provides the sample size.}

\item{pi0}{A \code{numeric} that provides the prevalence or proportion of people (in the whole population) who are positive, as measured through a non-random,
but systematic sampling (e.g. based on medical selection).}

\item{alpha0}{A \code{numeric} that corresponds to the probability that a random participant
has been incorrectly declared positive through the nontransparent procedure. In most applications,
this probability is likely very close to zero.}

\item{alpha}{A \code{numeric} that provides the False Negative (FN) rate for the sample R.}

\item{beta}{A \code{numeric} that provides the False Positive (FP) rate for the sample R.}

\item{...}{Additional arguments.}
}
\value{
Negative marginalized log-likelihood.
}
\description{
Log-Likelihood function based on R1 and R3 multiplied by -1.
}
\author{
Stephane Guerrier
}
\keyword{internal}
