% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polynomial.R
\name{pdNeville}
\alias{pdNeville}
\title{Polynomial interpolation of curves (1D) or surfaces (2D) of HPD matrices}
\usage{
pdNeville(P, X, x, metric = "Riemannian")
}
\arguments{
\item{P}{for polynomial curve interpolation, a \eqn{(d, d, N)}-dimensional array corresponding to a length \eqn{N} sequence
of \eqn{(d, d)}-dimensional HPD matrices (control points) through which the interpolating polynomial
curve passes. For polynomial surface interpolation, a \eqn{(d, d, N_1, N_2)}-dimensional array corresponding
to a tensor product grid of \eqn{(d, d)}-dimensional HPD matrices (control points) through which the interpolating
polynomial surface passes.}

\item{X}{for polynomial curve interpolation, a numeric vector of length \eqn{N} specifying the time points at which
the interpolating polynomial passes through the control points \code{P}. For polynomial surface interpolation, a list
with as elements two numeric vectors \code{x} and \code{y} of length \eqn{N_1} and \eqn{N_2} respectively. The numeric
vectors specify the time points on the tensor product grid \code{expand.grid(X$x, X$y)} at which the interpolating
polynomial passes trough the control points \code{P}.}

\item{x}{for polynomial curve interpolation, a numeric vector specifying the time points (locations) at which the
interpolating polynomial is evaluated. For polynomial surface interpolation, a list with as elements two numeric vectors
\code{x} and \code{y} specifying the time points (locations) on the tensor product grid \code{expand.grid(x$x, x$y)} at which the
interpolating polynomial surface is evaluated.}

\item{metric}{the metric on the space of HPD matrices, by default \code{metric = "Riemannian"}, but instead of the Riemannian metric
this can also be set to \code{metric = "Euclidean"} to perform (standard) Euclidean polynomial interpolation of curves or
surfaces in the space of HPD matrices.}
}
\value{
For polynomial curve interpolation, a \code{(d, d, length(x))}-dimensional array corresponding to the interpolating polynomial
curve of \eqn{(d,d)}-dimensional matrices of degree \eqn{N-1} evaluated at times \code{x} and passing through the control points \code{P}
at times \code{X}. For polynomial surface interpolation, a \code{(d, d, length(x$x), length(x$y))}-dimensional array corresponding to the
interpolating polynomial surface of \eqn{(d,d)}-dimensional matrices of bi-degree \eqn{N_1 - 1, N_2 - 1} evaluated at times \code{expand.grid(x$x, x$y)}
and passing through the control points \code{P} at times \code{expand.grid(X$x, X$y)}.
}
\description{
\code{pdNeville} performs intrinsic polynomial interpolation of curves or surfaces of HPD matrices
in the metric space of HPD matrices equipped with the affine-invariant Riemannian metric (see \insertCite{B09}{pdSpecEst}[Chapter 6]
or \insertCite{PFA05}{pdSpecEst}) via Neville's algorithm based on iterative geodesic interpolation detailed
in \insertCite{CvS17}{pdSpecEst} and in Chapter 3 and 5 of \insertCite{C18}{pdSpecEst}.
}
\details{
For polynomial curve interpolation, given \eqn{N} control points (i.e., HPD matrices), the degree of the
interpolated polynomial is \eqn{N - 1}. For polynomial surface interpolation, given \eqn{N_1 \times N_2} control points
(i.e., HPD matrices) on a tensor product grid, the interpolated polynomial surface is of bi-degree \eqn{(N_1 - 1, N_2 - 1)}.
Depending on the input array \code{P}, the function decides whether polynomial curve or polynomial surface interpolation
is performed.
}
\note{
If \code{metric = "Euclidean"}, the interpolating curve or surface may not be positive definite everywhere as the space of HPD
matrices equipped with the Euclidean metric has its boundary at a finite distance.

The function does not check for positive definiteness of the input matrices, and may fail if \code{metric = "Riemannian"} and
the input matrices are close to being singular.
}
\examples{
### Polynomial curve interpolation
P <- rExamples1D(50, example = 'gaussian')$f[, , 10*(1:5)]
P.poly <- pdNeville(P, (1:5)/5, (1:50)/50)
## Examine matrix-component (1,1)
plot((1:50)/50, Re(P.poly[1, 1, ]), type = "l") ## interpolated polynomial
lines((1:5)/5, Re(P[1, 1, ]), col = 2) ## control points

### Polynomial surface interpolation
P.surf <- array(P[, , 1:4], dim = c(2,2,2,2)) ## control points
P.poly <- pdNeville(P.surf, list(x = c(0, 1), y = c(0, 1)), list(x = (0:10)/10, y = (0:10)/10))

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{pdPolynomial}}
}
