% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylogenetic.R
\name{plot_two_tree}
\alias{plot_two_tree}
\title{Plot two trees in one plot}
\usage{
plot_two_tree(
  tree1,
  tree2,
  edge_df = NULL,
  tree2_x = 10,
  filter_link = FALSE,
  tree1_param = list(),
  tree2_param = list(),
  line_param = list(),
  tree1_tip = FALSE,
  tip1_param = list(),
  tree2_tip = FALSE,
  tip2_param = list(),
  tree1_highlight = NULL,
  highlight1_param = list(),
  highlight1_scale = NULL,
  tree2_highlight = NULL,
  highlight2_param = list(),
  highlight2_scale = ggplot2::scale_fill_hue(na.value = NA)
)
}
\arguments{
\item{tree1}{phylo object}

\item{tree2}{phylo object}

\item{edge_df}{dataframe with edge information, containing "from" and "to" columns}

\item{tree2_x}{x position of tree2}

\item{filter_link}{filter the link between tree1 and tree2}

\item{tree1_param}{parameters for \code{\link[ggtree]{geom_tree}}}

\item{tree2_param}{parameters for \code{\link[ggtree]{geom_tree}}}

\item{line_param}{parameters for \code{\link[ggplot2]{geom_line}}}

\item{tree1_tip}{tree tip label}

\item{tip1_param}{parameters for \code{\link[ggtree]{geom_tiplab}}}

\item{tree2_tip}{tree tip label}

\item{tip2_param}{parameters for \code{\link[ggtree]{geom_tiplab}}}

\item{tree1_highlight}{tree1 highlight data.frame}

\item{highlight1_param}{parameters for \code{\link[ggtree]{geom_hilight}}}

\item{highlight1_scale}{scale_fill_ for highlight1}

\item{tree2_highlight}{tree2 highlight data.frame}

\item{highlight2_param}{parameters for \code{\link[ggtree]{geom_hilight}}}

\item{highlight2_scale}{scale_fill_ for highlight2}
}
\value{
ggplot object
}
\description{
Plot two trees in one plot
}
\examples{
if (requireNamespace("ggtree")) {
  data(otutab, package = "pcutils")
  df2tree(taxonomy[1:50, ]) -> tax_tree
  df2tree(taxonomy[51:100, ]) -> tax_tree2
  link <- data.frame(from = sample(tax_tree$tip.label, 20), to = sample(tax_tree2$tip.label, 20))
  plot_two_tree(tax_tree, tax_tree2, link)
}
}
