% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{plot.NumArcs}
\alias{plot.NumArcs}
\title{Plot a \code{NumArcs} \code{object}}
\usage{
\method{plot}{NumArcs}(x, Jit = 0.1, ...)
}
\arguments{
\item{x}{Object of class \code{NumArcs}.}

\item{Jit}{A positive real number
that determines the amount of jitter along the \eqn{y}-axis,
default is 0.1, for the 1D case,
the vertices of the PCD are jittered
according to \eqn{U(-Jit,Jit)} distribution
along the \eqn{y}-axis where
\code{Jit} equals to the range of vertices
and the interval end points; it is redundant in the 2D case.}

\item{\dots}{Additional parameters for \code{plot}.}
}
\value{
None
}
\description{
Plots the scatter plot of the data points (i.e. vertices of the PCDs)
and the Delaunay tessellation of the nontarget points marked with number of arcs
in the centroid of the Delaunay cells.
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10
Xp<-runif.tri(n,Tr)$g
M<-as.numeric(runif.tri(1,Tr)$g)
Arcs<-arcsAStri(Xp,Tr,M)
Arcs
plot(Arcs)
}

}
\seealso{
\code{\link{print.NumArcs}}, \code{\link{summary.NumArcs}},
and \code{\link{print.summary.NumArcs}}
}
