% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{num.arcsCSstd.tri}
\alias{num.arcsCSstd.tri}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs)
and quantities related to the triangle - standard equilateral triangle case}
\usage{
num.arcsCSstd.tri(Xp, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the digraph.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates.
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
A \code{list} with the elements
\item{desc}{A short description of the output: number of arcs
and quantities related to the standard equilateral triangle}
\item{num.arcs}{Number of arcs of the CS-PCD}
\item{tri.num.arcs}{Number of arcs of the induced subdigraph of the CS-PCD
for vertices in the standard equilateral triangle \eqn{T_e}}
\item{num.in.tri}{Number of \code{Xp} points in the standard equilateral triangle, \eqn{T_e}}
\item{ind.in.tri}{The vector of indices of the \code{Xp} points that reside in \eqn{T_e}}
\item{tess.points}{Tessellation points, i.e., points on which the tessellation of
the study region is performed,
here, tessellation points are the vertices of the support triangle \eqn{T_e}.}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
}
\description{
An object of class \code{"NumArcs"}.
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs)
whose vertices are the
given 2D numerical data set, \code{Xp}.
It also provides number of vertices
(i.e., number of data points inside the standard equilateral triangle \eqn{T_e})
and indices of the data points that reside in \eqn{T_e}.

CS proximity region \eqn{N_{CS}(x,t)} is defined with respect to the standard
equilateral triangle \eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with expansion parameter \eqn{t>0}
and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \eqn{T_e} for this function.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

Narcs = num.arcsCSstd.tri(Xp,t=.5,M)
Narcs
summary(Narcs)
oldpar <- par(pty="s")
plot(Narcs,asp=1)
par(oldpar)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{num.arcsCStri}}, \code{\link{num.arcsCS}}, and \code{\link{num.arcsPEstd.tri}},
}
\author{
Elvan Ceyhan
}
