% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{arcsPEtri}
\alias{arcsPEtri}
\title{The arcs of Proportional Edge Proximity Catch Digraph
(PE-PCD) for 2D data - one triangle case}
\usage{
arcsPEtri(Xp, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the vertices of the PE-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri}
or the circumcenter of \code{tri}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e.,
the center of mass of \code{tri}.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph,
the center \code{M} used to
construct the vertex regions and the expansion parameter \code{r}.}
\item{tess.points}{Tessellation points, i.e., points on which the tessellation of
the study region is performed,
here, tessellation points are the vertices of the support triangle \code{tri}.}
\item{tess.name}{Name of the tessellation points \code{tess.points}}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set
which constitutes the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of PE-PCD
for 2D data set \code{Xp}
as vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of PE-PCD
for 2D data set \code{Xp}
as vertices of the digraph}
\item{mtitle}{Text for \code{"main"} title
in the plot of the digraph}
\item{quant}{Various quantities for the digraph:
number of vertices, number of partition points,
number of triangles, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs of PE-PCD as tails (or sources) and heads (or arrow ends)
and related parameters and the quantities of the digraph.
The vertices of the PE-PCD are the data points in \code{Xp}
in the one triangle case.

PE proximity regions are constructed
with respect to the triangle \code{tri} with expansion
parameter \eqn{r \ge 1}, i.e.,
arcs may exist only for points inside \code{tri}.
It also provides various descriptions
and quantities about the arcs of the PE-PCD
such as number of arcs, arc density, etc.

Vertex regions are based on center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)}
in barycentric coordinates in the interior of
the triangle \code{tri} or based on the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \code{tri}.
When the center is the circumcenter, \code{CC},
the vertex regions are constructed based on the
orthogonal projections to the edges,
while with any interior center \code{M},
the vertex regions are constructed using the extensions
of the lines combining vertices with \code{M}.
\code{M}-vertex regions are recommended spatial inference,
due to geometry invariance property of the arc density
and domination number the PE-PCDs based on uniform data.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

r<-1.5  #try also r<-2

Arcs<-arcsPEtri(Xp,Tr,r,M)
#or try with the default center Arcs<-arcsPEtri(Xp,Tr,r); M= (Arcs$param)$cent
Arcs
summary(Arcs)
plot(Arcs)

#can add vertex regions
#but we first need to determine center is the circumcenter or not,
#see the description for more detail.
CC<-circumcenter.tri(Tr)
if (isTRUE(all.equal(M,CC)))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
} else
{cent<-M
cent.name<-"M"
Ds<-prj.cent2edges(Tr,M)
}
L<-rbind(cent,cent,cent); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

#now we can add the vertex names and annotation
txt<-rbind(Tr,cent,Ds)
xc<-txt[,1]+c(-.02,.02,.02,.02,.03,-.03,-.01)
yc<-txt[,2]+c(.02,.02,.03,.06,.04,.05,-.07)
txt.str<-c("A","B","C","M","D1","D2","D3")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{arcsPE}}, \code{\link{arcsAStri}},
and \code{\link{arcsCStri}}
}
\author{
Elvan Ceyhan
}
