% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcal.R
\name{pcal}
\alias{pcal}
\title{Lower Bounds on the Posterior Probabilities of Point Null Hypotheses}
\usage{
pcal(p, prior_prob = 0.5)
}
\arguments{
\item{p}{A numeric vector with values in the [0,1] interval.}

\item{prior_prob}{A numeric vector with values in the [0,1] interval. If \code{length(p) == 1} then \code{prior_prob} can be of any positive \code{\link[base]{length}}, but if \code{length(p) > 1} then the \code{\link[base]{length}} of \code{prior_prob} can only be \code{1} or equal to the \code{\link[base]{length}} of \code{p}.}
}
\value{
If \code{length(p) > 1} then \code{pcal} returns a numeric vector with the same \code{\link[base]{length}} as \code{p}, otherwise it returns a numeric vector with the same \code{\link[base]{length}} as \code{prior_prob}.
}
\description{
Calibrate p-values under a robust perspective so that they can be interpreted as either lower bounds on the posterior probabilities of point null hypotheses or as lower bounds on the probabilities of type I errors.
}
\details{
\insertCite{sellke2001;textual}{pcal} developed a calibration of p-values into lower bounds for the posterior probabilities of point null hypotheses or lower bounds for the probabilities of type I errors for the case when both the null and the alternative hypotheses have 0.5 prior probability. \code{pcal} generalizes the aforementioned calibration for prior probabilities other than 0.5.

\code{pcal} starts by transforming the values in \code{p} into lower bounds on Bayes factors using {\link[pcal]{bcal}} and then uses {\link[pcal]{bfactor_to_prob}} together with prior probabilities \code{prior_prob} to turn those Bayes factors into posterior probabilities. For each element of \code{p}, \code{pcal} returns an  approximation of the smallest posterior probability of the null hypothesis that is found by changing the prior distribution of the parameter of interest (under the alternative hypothesis) over wide classes of distributions.

The \code{prior_prob} argument is optional and is set to 0.5 by default, implying prior equiprobability of hypotheses. \code{prior_prob} can only be of \code{\link[base]{length}} equal to  the \code{length} of \code{p}, in which case each prior probability in \code{prior_prob} is used in the calibration of the corresponding element of \code{p}, or of \code{\link[base]{length}} \code{1}, in which case it will be recycled (if \code{length(p) > 1}) and the same \code{prior_prob} value is used in the calibration of all the elements of \code{p}.

The output of \code{pcal} can also be interpreted as lower bounds on the probabilities of type I errors. Note that the output of this calibration has both Bayesian and Frequentist interpretations. \insertCite{sellke2001;textual}{pcal} noted that a scenario in which they definitely recommend this calibration is when investigating fit to the null model with no explicit alternative in mind. \insertCite{pericchiTorres2011;textual}{pcal} warn that despite the usefulness and appropriateness of this p-value calibration it does not depend on sample size, and hence the lower bounds obtained with large samples may be conservative.
}
\examples{
# Calibration of a typical "threshold" p-value:
pcal(.05)

# Calibration of typical "threshold" p-values:
pcal(c(.1, .05, .01, .005, .001))

# Application: chi-squared goodness-of-fit test,
# lower bound on the posterior probability of the null hypothesis:
x <- matrix(c(12, 41, 25, 33), ncol = 2)
pcal(chisq.test(x)[["p.value"]])

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item {\link[pcal]{bcal}} for a p-value calibration that returns lower bounds on Bayes factors in favor of point null hypotheses.
}
}
