% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfactor_log_interpret.R
\name{bfactor_log_interpret}
\alias{bfactor_log_interpret}
\title{Interpretation of the logarithms of Bayes factors}
\usage{
bfactor_log_interpret(bf, base = exp(1))
}
\arguments{
\item{bf}{A numeric vector.}

\item{base}{A numeric vector of \code{\link[base]{length}} one. Must be a positive number.}
}
\value{
Returns a character vector with the same  \code{\link[base]{length}} as \code{bf}.
}
\description{
Quantify the strength of the evidence provided by the data to a model/hypothesis according to the Bayes factor interpretation scale suggested by \insertCite{jeffreys1961;textual}{pcal}.
}
\details{
Bayes factors are a summary of the evidence provided by the data to a model/hypothesis, and are often reported on a logarithmic scale. \insertCite{jeffreys1961;textual}{pcal} suggested the interpretation of Bayes factors in half-units on the base 10 logarithmic scale, as indicated in the following table:\tabular{lll}{
   \strong{log10(Bayes factor)} \tab \strong{Bayes factor} \tab \strong{Evidence} \cr
   [-Inf, 0[ \tab [0, 1[ \tab Negative \cr
   [0, 0.5[ \tab [1, 3.2[ \tab Weak \cr
   [0.5, 1[ \tab [3.2, 10[ \tab Substantial \cr
   [1, 1.5[ \tab [10, 32[ \tab Strong \cr
   [1.5, 2[ \tab [32, 100[ \tab Very Strong \cr
   [2, +Inf[ \tab [100, +Inf[ \tab Decisive \cr
}


\code{bfactor_log_interpret} takes (base \code{base}) logarithms of Bayes factors as input and returns the strength of the evidence provided by the data in favor of the  model/hypothesis in the numerator of the Bayes factors (usually the null hypothesis) according to the according to the aforementioned table.

When comparing results with those from standard likelihood ratio tests, it is convenient to put the null hypothesis in the denominator of the Bayes factor so that \code{bfactor_log_interpret} returns the strength of the evidence against the null hypothesis. If \code{bf} was obtained with the null hypothesis on the numerator, one can use \code{bfactor_log_interpret(1/bf)} to obtain the strength of the evidence against the null hypothesis.
}
\examples{
# Interpretation of one Bayes factor (on the natural log scale)
bfactor_log_interpret(log(1.5))

# Interpretation of many Bayes factors (on the natural log scale)
bfactor_log_interpret(log(c(0.1, 1.2, 3.5, 13.9, 150)))

# Interpretation of many Bayes factors (on the log10 scale)
bfactor_log_interpret(log10(c(0.1, 1.2, 3.5, 13.9, 150)), base = 10)

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[pcal]{bfactor_log_interpret_kr}} for an alternative interpretation scale.
\item \code{\link[pcal]{bfactor_interpret}} and \code{\link[pcal]{bfactor_interpret_kr}} for the interpretation of Bayes factors in levels.
\item \code{\link[pcal]{bfactor_to_prob}} to turn Bayes factors into posterior probabilities.
\item \code{\link[pcal]{bcal}} for a p-value calibration that returns lower bounds on Bayes factors in favor of point null hypotheses.
}
}
