% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcal.R
\name{bcal}
\alias{bcal}
\title{Lower Bounds on Bayes Factors for Point Null Hypotheses}
\usage{
bcal(p)
}
\arguments{
\item{p}{A numeric vector with values in the [0,1] interval.}
}
\value{
\code{bcal} returns a numeric vector with the same \code{\link[base]{length}} as \code{p}.
}
\description{
Calibrate p-values under a robust Bayesian perspective so that they can be interpreted as lower bounds on Bayes factors in favor of point null hypotheses.
}
\details{
\code{bcal} uses the calibration of p-values into lower bounds for Bayes factors developed in \insertCite{sellke2001;textual}{pcal}: \deqn{B(p) = -e \, p \, log (p)}{B(p) = -e p log (p)} for \code{p} < (1/e) and \deqn{B(p) = 1} otherwise, where \code{p} is a  p-value on a classical test statistic and \eqn{B(p)} approximates the smallest Bayes factor that is found by changing the prior distribution of the parameter of interest (under the alternative hypothesis) over wide classes of distributions.

\insertCite{sellke2001;textual}{pcal} noted that a scenario in which they definitely recommend this calibration is when investigating fit to the null model/hypothesis with no explicit alternative in mind. \insertCite{pericchiTorres2011;textual}{pcal} warn that despite the usefulness and appropriateness of this p-value calibration it does not depend on sample size and hence the lower bounds obtained with large samples may be conservative.
}
\examples{
# Calibration of a typical "threshold" p-value:
bcal(.05)

# Calibration of typical "threshold" p-values:
bcal(c(.1, .05, .01, .005, .001))

# Application: chi-squared goodness-of-fit test,
# lower bound on the Bayes factor in favor of the null hypothesis:
x <- matrix(c(12, 41, 25, 33), ncol = 2)
bcal(chisq.test(x)[["p.value"]])

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[pcal]{pcal}} for a p-value calibration that returns lower bounds on the posterior probabilities of point null hypotheses.
\item \code{\link[pcal]{bfactor_interpret}} and \code{\link[pcal]{bfactor_interpret_kr}} for the interpretation of Bayes factors.
\item \code{\link[pcal]{bfactor_log_interpret}} and \code{\link[pcal]{bfactor_log_interpret_kr}} for the interpretation of the logarithms of Bayes factors.
\item \code{\link[pcal]{bfactor_to_prob}} to turn Bayes factors into posterior probabilities.
}
}
