% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_custom.R
\name{s3_generate_presigned_url}
\alias{s3_generate_presigned_url}
\title{Generate a presigned url given a client, its method, and arguments}
\usage{
s3_generate_presigned_url(client_method, params=list(), expires_in=3600,
http_method = NULL)
}
\arguments{
\item{client_method}{(character): The client method to presign for}

\item{params}{(list): The parameters normally passed to \code{client_method}.}

\item{expires_in}{(numeric): The number of seconds the presigned url is valid
for. By default it expires in an hour (3600 seconds)}

\item{http_method}{(character) The http method to use on the generated url. By default,
the http method is whatever is used in the method's model.}
}
\value{
The presigned url character
}
\description{
Generate a presigned url given a client, its method, and arguments
}
\section{Request syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc$generate_signed_url(
  client_method = "string",
  params = "list",
  expires_in = "numeric",
  http_method = "string"
)
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
# The following example generates a presigned URL that you
# can give to others so that they can retrieve an object from an S3 bucket.
svc$generate_signed_url(
  client_method = "get_object",
  Params = list(Bucket = "BUCKET_NAME", Key = "OBJECT_KEY"),
  ExpiresIn = 3600
)
}
}
\keyword{internal}
