% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_list_resources_for_web_acl}
\alias{wafv2_list_resources_for_web_acl}
\title{Retrieves an array of the Amazon Resource Names (ARNs) for the resources
that are associated with the specified web ACL}
\usage{
wafv2_list_resources_for_web_acl(WebACLArn, ResourceType = NULL)
}
\arguments{
\item{WebACLArn}{[required] The Amazon Resource Name (ARN) of the web ACL.}

\item{ResourceType}{Retrieves the web ACLs that are used by the specified resource type.

For Amazon CloudFront, don't use this call. Instead, use the CloudFront
call \code{ListDistributionsByWebACLId}. For information, see
\href{https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html}{ListDistributionsByWebACLId}
in the \emph{Amazon CloudFront API Reference}.

If you don't provide a resource type, the call uses the resource type
\code{APPLICATION_LOAD_BALANCER}.

Default: \code{APPLICATION_LOAD_BALANCER}}
}
\description{
Retrieves an array of the Amazon Resource Names (ARNs) for the resources that are associated with the specified web ACL.

See \url{https://www.paws-r-sdk.com/docs/wafv2_list_resources_for_web_acl/} for full documentation.
}
\keyword{internal}
