% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_create_data_source}
\alias{bedrockagent_create_data_source}
\title{Connects a knowledge base to a data source}
\usage{
bedrockagent_create_data_source(
  clientToken = NULL,
  dataDeletionPolicy = NULL,
  dataSourceConfiguration,
  description = NULL,
  knowledgeBaseId,
  name,
  serverSideEncryptionConfiguration = NULL,
  vectorIngestionConfiguration = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{dataDeletionPolicy}{The data deletion policy for the data source.

You can set the data deletion policy to:
\itemize{
\item DELETE: Deletes all data from your data source that’s converted into
vector embeddings upon deletion of a knowledge base or data source
resource. Note that the \strong{vector store itself is not deleted}, only
the data. This flag is ignored if an Amazon Web Services account is
deleted.
\item RETAIN: Retains all data from your data source that’s converted into
vector embeddings upon deletion of a knowledge base or data source
resource. Note that the \strong{vector store itself is not deleted} if
you delete a knowledge base or data source resource.
}}

\item{dataSourceConfiguration}{[required] The connection configuration for the data source.}

\item{description}{A description of the data source.}

\item{knowledgeBaseId}{[required] The unique identifier of the knowledge base to which to add the data
source.}

\item{name}{[required] The name of the data source.}

\item{serverSideEncryptionConfiguration}{Contains details about the server-side encryption for the data source.}

\item{vectorIngestionConfiguration}{Contains details about how to ingest the documents in the data source.}
}
\description{
Connects a knowledge base to a data source. You specify the configuration for the specific data source service in the \code{dataSourceConfiguration} field.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_create_data_source/} for full documentation.
}
\keyword{internal}
