% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_create_group}
\alias{xray_create_group}
\title{Creates a group resource with a name and a filter expression}
\usage{
xray_create_group(
  GroupName,
  FilterExpression = NULL,
  InsightsConfiguration = NULL,
  Tags = NULL
)
}
\arguments{
\item{GroupName}{[required] The case-sensitive name of the new group. Default is a reserved name and
names must be unique.}

\item{FilterExpression}{The filter expression defining criteria by which to group traces.}

\item{InsightsConfiguration}{The structure containing configurations related to insights.
\itemize{
\item The InsightsEnabled boolean can be set to true to enable insights
for the new group or false to disable insights for the new group.
\item The NotificationsEnabled boolean can be set to true to enable
insights notifications for the new group. Notifications may only be
enabled on a group with InsightsEnabled set to true.
}}

\item{Tags}{A map that contains one or more tag keys and tag values to attach to an
X-Ray group. For more information about ways to use tags, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}
in the \emph{Amazon Web Services General Reference}.

The following restrictions apply to tags:
\itemize{
\item Maximum number of user-applied tags per resource: 50
\item Maximum tag key length: 128 Unicode characters
\item Maximum tag value length: 256 Unicode characters
\item Valid values for key and value: a-z, A-Z, 0-9, space, and the
following characters: _ . : / = + - and @
\item Tag keys and values are case sensitive.
\item Don't use \verb{aws:} as a prefix for keys; it's reserved for Amazon Web
Services use.
}}
}
\description{
Creates a group resource with a name and a filter expression.

See \url{https://www.paws-r-sdk.com/docs/xray_create_group/} for full documentation.
}
\keyword{internal}
