% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-pv-data.R
\name{unnest_pv_data}
\alias{unnest_pv_data}
\title{Unnest PatentsView data}
\usage{
unnest_pv_data(data, pk = get_ok_pk(names(data)))
}
\arguments{
\item{data}{The data returned by \code{\link{search_pv}}. This is the first
element of the three-element result object you got back from
\code{search_pv}. It should be a list of length 1, with one data frame
inside it. See examples.}

\item{pk}{The column/field name that will link the data frames together. This
should be the unique identifier for the primary entity. For example, if you
used the patents endpoint in your call to \code{search_pv}, you could
specify \code{pk = "patent_number"}. \strong{This identifier has to have
been included in your \code{fields} vector when you called
\code{search_pv}}. You can use \code{\link{get_ok_pk}} to suggest a
potential primary key for your data.}
}
\value{
A list with multiple data frames, one for each entity/subentity.
  Each data frame will have the \code{pk} column in it, so you can link the
  tables together as needed.
}
\description{
This function converts a single data frame that has subentity-level list
columns in it into multiple data frames, one for each entity/subentity.
The multiple data frames can be merged together using the primary key
variable specified by the user (see the
\href{https://r4ds.had.co.nz/relational-data.html}{relational data} chapter
in "R for Data Science" for an in-depth introduction to joining tabular data).
}
\examples{
\dontrun{

fields <- c("patent_number", "patent_title", "inventor_city", "inventor_country")
res <- search_pv(query = '{"_gte":{"patent_year":2015}}', fields = fields)
unnest_pv_data(data = res$data, pk = "patent_number")
}

}
