# set up data path for this test
data_path <- file.path(tempdir(), "pastclim_data")
# it should not exist, but remove it just in case
unlink(data_path, recursive = TRUE)
# set data path
set_data_path(
  path_to_nc = data_path,
  ask = FALSE,
  write_config = FALSE,
  copy_example = TRUE
)
################################################################################

test_that("climate_for_time_slice", {
  climate_region <- region_series(
    time_bp = c(-20000, -10000),
    bio_variables = c("bio01", "bio12"),
    dataset = "Example"
  )
  my_slice <- slice_region_series(climate_region, time_bp = -10000)
  expect_true(inherits(my_slice, "SpatRaster"))
  expect_true(length(my_slice) == 1)
  expect_true(terra::nlyr(my_slice) == 2)
  expect_true(all(varnames(my_slice) == c("bio01", "bio12")))
  # now do the same with time_ce
  my_slice_ce <- slice_region_series(climate_region, time_ce = -8050)
  expect_identical(time(my_slice), time(my_slice_ce))

  # use a time step that does not exist
  expect_error(
    slice_region_series(climate_region, time_bp = -19000),
    "time_bp is not a time slice within the region series x"
  )
  # use too many timesteps
  expect_error(
    slice_region_series(climate_region, time_bp = c(-10000, -20000)),
    "time_bp should be a single time step"
  )
  # pass an object that is not valid
  climate_region[1] <- climate_region[1][[1]]
  expect_error(
    slice_region_series(climate_region, time_bp = -10000),
    "x is not a valid object generated by region_series"
  )
})

################################################################################
# clean up for the next test
unlink(data_path, recursive = TRUE)
