% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflow_fields.R
\name{reflow_fields}
\alias{reflow_fields}
\title{Reflow potentially invalid time components to adjacent fields}
\usage{
reflow_fields(fmat, days)
}
\arguments{
\item{fmat}{a fields matrix as part of a partial_time or partial_difftime}

\item{days}{a logical indicating whether year and month should be consolidated
into total days. If an integer is provided, days should represent the
"leap-time" to add on top of non-leap conversion.}
}
\value{
a fields matrix with appropriately ranged time components
}
\description{
Reflow potentially invalid time components to adjacent fields
}
\examples{

# example with difftimes (when you only care about days of change)

x <- as.parttime("2019-06-23 04:33:21.123")
y <- as.parttime("2018-02-08 12:59:28.987")

diff_fields <- vctrs::field(x, "pttm_mat") - vctrs::field(y, "pttm_mat")

parttime:::reflow_fields(diff_fields)

# if we want to assume 0.25 leap days per year
parttime:::reflow_fields(diff_fields, days = TRUE)

# if we want to assert that there were no leap days
parttime:::reflow_fields(diff_fields, days = 0)

}
