% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_design_random.R
\name{generate_design_random}
\alias{generate_design_random}
\title{Generate a Random Design}
\usage{
generate_design_random(param_set, n)
}
\arguments{
\item{param_set}{(\code{\link{ParamSet}}).}

\item{n}{(\code{integer(1)})\cr
Number of points to draw randomly.}
}
\value{
\code{\link{Design}}.
}
\description{
Generates a design with randomly drawn points.
Internally uses \code{\link{SamplerUnif}}, hence, also works for \link{ParamSet}s with dependencies.
If dependencies do not hold, values are set to \code{NA} in the resulting data.table.
}
\examples{
pset = ps(
  ratio = p_dbl(lower = 0, upper = 1),
  letters = p_fct(levels = letters[1:3])
)
generate_design_random(pset, 10)
}
\seealso{
Other generate_design: 
\code{\link{generate_design_grid}()},
\code{\link{generate_design_lhs}()},
\code{\link{generate_design_sobol}()}
}
\concept{generate_design}
