% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamr.adaptthresh.R
\name{pamr.batchadjust}
\alias{pamr.batchadjust}
\title{A function to mean-adjust microarray data by batches}
\usage{
pamr.batchadjust(data)
}
\arguments{
\item{data}{The input data. A list with components: x- an expression genes
in the rows, samples in the columns, and y- a vector of the class labels for
each sample, and batchlabels- a vector of batch labels for each sample.}
}
\value{
A data object of the same form as the input data, with x replaced by
the adjusted x
}
\description{
A function to mean-adjust microarray data by batches
}
\details{
\code{pamr.batchadjust} does a genewise one-way ANOVA adjustment for
expression values.  Let \eqn{x(i,j)} be the expression for gene \eqn{i} in sample \eqn{j}.
Suppose sample \eqn{j} in in batch \eqn{b}, and let \eqn{B} be the set of all samples in batch
\eqn{b}. Then \code{pamr.batchadjust} adjusts \eqn{x(i,j)} to \eqn{x(i,j) - mean[x(i,j)]}
where the mean is taken over all samples \eqn{j} in \eqn{B}.
}
\examples{

suppressWarnings(RNGversion("3.5.0"))
set.seed(120)
#generate some data
x <- matrix(rnorm(1000*20),ncol=20)
y <- sample(c(1:4),size=20,replace=TRUE)
batchlabels <- sample(c(1:5),size=20,replace=TRUE)
mydata <- list(x=x,y=factor(y),batchlabels=factor(batchlabels))

mydata2 <- pamr.batchadjust(mydata)

}
\author{
Trevor Hastie,Robert Tibshirani, Balasubramanian Narasimhan, and
Gilbert Chu
}
