% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paletteer_d.R
\name{paletteer_d}
\alias{paletteer_d}
\title{Get discrete palette by package and name}
\usage{
paletteer_d(
  palette,
  n,
  direction = 1,
  type = c("discrete", "continuous"),
  call = caller_env(0)
)
}
\arguments{
\item{palette}{Name of palette as a string. Must be on the form
packagename::palettename.}

\item{n}{Number of colors desired. If omitted, returns complete palette.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{type}{Either "discrete" or "continuous". Colors are interpolated if
"continuous" is picked. Defaults to "discrete".}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A vector of colors.
}
\description{
Available package/palette combinations are available in the data.frame
\code{\link[paletteer]{palettes_d_names}}.
}
\examples{
paletteer_d("nord::frost")
paletteer_d("wesanderson::Royal1", 3)
paletteer_d("Redmonder::dPBIPuOr", 14, type = "continuous")
}
