#' Cognate Data Distance Matrix
#'
#' A [`dist`] object describing distances between 87 Indo-European languages from
#' the perspective of cognates.
#'
#' Cognate relationships from a collection of essential words were collected
#' from Dyen et al. and encoded in a 87x2665 binary matrix from which this
#' distance matrix was derived (using Euclidean distance).
#'
#' @references I. Dyen, J. B. Kruskal, P. Black, An Indoeuropean
#' classification: A lexicostatistical experiment. Trans. Am. Phil. Soc. 82,
#' iii-132 (1992).
#'
#' @format A [`dist`] object for 87 Indo-European languages.
#'
"cognate_dist"
