% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_last.R
\name{pac_islast}
\alias{pac_islast}
\title{Checking if a package version is the most recent one}
\usage{
pac_islast(pac, version = NULL, lib.loc = .libPaths(), repos = biocran_repos())
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{version}{\code{character} version of a package. Default: \code{NULL}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{repos}{\code{character} vector of repositories URLs to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
\code{logical} if a package is inside repositories.
}
\description{
checking if a package version is the most recent one, by default the installed version is compared.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
}
\examples{
\dontrun{
pac_islast("memoise")
pac_islast("dplyr", version = "1.0.0")
pac_islast("S4Vectors")
pac_islast("S4Vectors", version = pac_last("S4Vectors"))
}
}
