% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtrack.R
\name{backtrack}
\alias{backtrack}
\title{Move backwards from the minimum to a more conservative solution.}
\usage{
backtrack(x, max_total_rise = 0.1, max_step_rise = 0.05)
}
\arguments{
\item{x}{Vector of dissimilarity values corresponding to consecutive and
increasing numbers of outliers.}

\item{max_total_rise}{Upper limit for the cumulative increase, as a
proportion of the global minimum dissimilarity, from
all backward steps.}

\item{max_step_rise}{Upper limit for the increase, as a proportion of the
global minimum dissimilarity, from each backward step.}
}
\value{
\code{backtrack} returns a list with two elements, \code{minimum} and \code{backtrack}:
\describe{
\item{\code{minimum} is a list with the following elements:}{
\describe{
\item{\code{ind}}{Index of the minimum solution.}
\item{\code{val}}{Value of the minimum solution.}
}
}
\item{\code{backtrack} is a list with the following elements:}{
\describe{
\item{\code{ind}}{Index of the backtrack solution.}
\item{\code{val}}{Value of the backtrack solution.}
}
}
}
}
\description{
Given a vector of dissimilarity values, each corresponding to a different
number of outliers, this function first finds the index and value of the
minimum dissimilarity, then moves backwards from right to left to a
reasonable solution with a lower index (i.e. lower number of outliers).
Limits are placed on the maximum increase in dissimilarity from a single step
(\code{max_step_rise}) and from all steps (\code{max_total_rise}), where both are
defined in proportion to the minimum dissimilarity value.
}
\examples{
ombc_gmm_k3n1000o10 <-
  ombc_gmm(gmm_k3n1000o10[, 1:2], comp_num = 3, max_out = 20)

backtrack(ombc_gmm_k3n1000o10$distrib_diff_vec)
}
