% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combined_dataset.R
\name{combined_dataset}
\alias{combined_dataset}
\title{Returns the combined formatted OULAD}
\usage{
combined_dataset(
  module = c("AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG"),
  presentation = c("2013J", "2014J", "2013B", "2014B", "All"),
  repeat_students = c("remove", "keep"),
  withdrawn_students = c("remove", "keep"),
  demographics = FALSE,
  registration = FALSE,
  VLE = c("omit", "daily", "weekly", "activity", "FSLM", "FSLSM", "OLS", "VARK"),
  VLE_clicks = c("total", "binary", "standardise1", "standardise2", "logarithmic"),
  week_begin = -4,
  week_end = 39,
  assessment = FALSE,
  na.rm = FALSE,
  example_data = FALSE
)
}
\arguments{
\item{module}{name of the module to be included, either \code{"AAA"}, \code{"BBB"}, \code{"CCC"},
\code{"DDD"}, \code{"EEE"}, \code{"FFF"} or \code{"GGG"}.}

\item{presentation}{name of the semester of the module to be included, either \code{"2013B"},
\code{"2014B"}, \code{"2013J"}, \code{"2014J"}, or \code{"All"}.
\code{"B"} indicates a February start time whereas \code{"J"} indicates an October start time. \code{"All"} indicates that all presentations of the module will be included in the returned data.}

\item{repeat_students}{indicator of whether students who had previous attempts at the module should be removed, either \code{"remove"} or \code{"keep"}.
When presentation is set to \code{"All"}, this value is set to \code{"remove"}.}

\item{withdrawn_students}{indicator of whether students who had withdrawn from the module should be removed, either \code{"remove"} or \code{"keep"}.
Students are removed based on whether they have withdrawn by the \code{"week_end"} value.}

\item{demographics}{logical. Indicates whether demographic data is included in the outputted data set.}

\item{registration}{logical. Indicates whether registration data is included in the outputted data set.}

\item{VLE}{indicates whether VLE data is included in the outputted data set
(default is \code{"omit"} - VLE data not to be included).
If included, the VLE data can be returned based on \code{"weekly"} VLE interactions, \code{"daily"} VLE
interactions or interactions according to Open University activities (\code{"activity"}).
The VLE data can also be returned as classified under a
specific learning model, either \code{"FSLM"}, \code{"FSLSM"}, \code{"OLS"}, or \code{"VARK"}.}

\item{VLE_clicks}{indicates the format that the VLE data should be returned as, either \code{"total"} views (default),
\code{"binary"} views, \code{"standardise1"} (standardises each variable individually by using the scale function),
\code{"standardise2"} (performs global standardisation of the data set), or \code{"logarithmic"} values.}

\item{week_begin}{the first semester week of VLE and assessment data to be included in formatted data. Depending on the module presentation, students
started to view activities four weeks prior to the initial module start date. Weeks prior to the initial module start
are indicated by a negative integer.}

\item{week_end}{the last semester week of VLE and assessment data to be included in the formatted data.
Week 39 is the last week material was viewed (and earlier in some module presentations).
This parameter is also used to remove withdrawn students.}

\item{assessment}{logical. Indicates whether assessment data is included in the outputted data set.}

\item{na.rm}{logical. Indicates whether NAs should be omitted from the average continuous assessment calculations
or treated as zeroes (default). This calculation only includes continuous assessment that
was due between the period set by \code{"week_begin"} and \code{"week_end"} inclusive,
and only occurs when a specific module presentation is requested (e.g., 'BBB 2013J').}

\item{example_data}{logical. Indicates whether to run a subset of the VLE data as an example.}
}
\value{
Returns the inputs specified for whether assessment, demographics, registration and VLE variables are to be included,
as well as the other inputs. Also, one \code{tibble} (object of class \code{tbl_df}) is returned, dataset_combined.
}
\description{
Combines multiple OULAD .csv files into one tibble that is formatted for data analysis and
where each row represents a unique student.
}
\section{dataset_combined tibble}{

A \code{tibble} where each row represents a unique student. Depending on the inputs specified,
the \code{tibble} includes assessment, demographics, registration and VLE data for each student.
}

\examples{
# Uses subset of the VLE data set for example
combined_dataset(module = "AAA", presentation = "2013J",
repeat_students = "remove", withdrawn_students = "remove",
demographics = TRUE, registration = TRUE,
assessment = TRUE, na.rm = FALSE,
VLE = "weekly", VLE_clicks = "total",
example_data = TRUE)
\donttest{
# Slow to run as it loads the full VLE data set
combined_dataset(module = "BBB", presentation = "2013J",
repeat_students = "remove", withdrawn_students = "remove",
demographics = TRUE, registration = FALSE,
assessment = TRUE, na.rm = FALSE,
VLE = "activity", VLE_clicks = "standardise1",
week_begin = -4, week_end = 14, example_data = FALSE)}
}
\references{
Kuzilek, J., Hlosta, M., & Zdrahal, Z. (2017). Open university learning analytics dataset. Scientific Data
volume 4 , (pp. 1–8). https://doi.org/10.1038/sdata.2017.171.
}
\seealso{
For more information on different inputs and variables in the dataset_combined \code{tibble}, see:
\itemize{
\item{ \code{\link[=dataset_assessment]{dataset_assessment()}} for information on the assessment performance data,}
\item{\code{\link[=dataset_demographics]{dataset_demographics()}} for information on the demographics data,}
\item{\code{\link[=dataset_registration]{dataset_registration()}} for information on the registration data,}
\item{\code{\link[=dataset_VLE_time]{dataset_VLE_time()}} for information on the VLE daily or weekly data,}
\item{\code{\link[=dataset_VLE_activity]{dataset_VLE_activity()}} for information on the VLE activity data,}
\item{\code{\link[=VLE_learning_classification]{VLE_learning_classification()}} for information on the VLE activities classified under a learning model, and}
\item{\code{\link[=convert_VLE]{convert_VLE()}} for information on transforming the data type of the VLE data.}
}
}
