% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_mv.R
\name{osf_mv}
\alias{osf_mv}
\title{Move a file or directory}
\usage{
osf_mv(x, to, overwrite = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{An \code{\link{osf_tbl_file}} containing a single file or directory.}

\item{to}{Destination where the file or directory will be moved. This
can be one of the following:
\itemize{
\item An \code{\link{osf_tbl_node}} with a single project or component.
\item An \code{\link{osf_tbl_file}} with a single directory.
}}

\item{overwrite}{Logical, if a file or directory with the same name already
exists at the destination should it be replaced with \code{x}?}

\item{verbose}{Logical, indicating whether to print informative messages
about interactions with the OSF API (default \code{FALSE}).}
}
\value{
An \code{\link{osf_tbl_file}} containing the updated OSF file.
}
\description{
Use \code{osf_mv()} to move a file or directory to a new project, component, or
subdirectory.
}
\details{
Note that a file (or directory) cannot be moved or copied onto itself, even
if \code{overwrite = TRUE}.
}
\examples{
\dontrun{
# Create an example file to upload to our example project
project <- osf_create_project("Flower Data")

write.csv(iris, file = "iris.csv")
data_file <- osf_upload(project,"iris.csv")

# Create a new directory to move our file to
data_dir <- osf_mkdir(project, "data")

# Move the file to our data directory
data_file <- osf_mv(data_file, to = data_dir)

# Move our data directory to a new component
data_comp <- osf_create_component(project, title = "data", category = "data")
data_dir \%>\%
  osf_mv(to = data_comp) \%>\%
  osf_open()
}

}
\seealso{
Other OSF file operations: 
\code{\link{osf_cp}()},
\code{\link{osf_mkdir}()},
\code{\link{osf_rm}()}
}
\concept{OSF file operations}
