% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep_gld_purchases}
\alias{keep_gld_purchases}
\title{Keep rows with purchases of glucose lowering drugs (GLD)}
\usage{
keep_gld_purchases(lmdb)
}
\arguments{
\item{lmdb}{The \code{lmdb} register.}
}
\value{
The same type as the input data, as a \code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}}.
Only rows with glucose lowering drug purchases are kept, plus some columns are renamed.
}
\description{
This function doesn't keep glucose-lowering drugs that may be used for other
conditions than diabetes like GLP-RAs or dapagliflozin/empagliflozin drugs.
Since the diagnosis code data on pregnancies (see below) is insufficient to
perform censoring prior to 1997, \code{\link[=keep_gld_purchases]{keep_gld_purchases()}} only extracts
dates from 1997 onward by default (if Medical Birth Register data is
available to use for censoring, the extraction window can be extended).
}
\seealso{
See the \code{vignette("algorithm")} for the logic used to filter these
patients.
}
\keyword{internal}
