% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orientation.R
\name{orthogonal-planes}
\alias{orthogonal-planes}
\alias{is.axial}
\alias{is.coronal}
\alias{is.sagittal}
\title{Orthogonal Planes}
\usage{
is.axial(imageOrientationPatient, axial = c("L", "R", "A", "P"))

is.coronal(imageOrientationPatient, coronal = c("L", "R", "H", "F"))

is.sagittal(imageOrientationPatient, sagittal = c("A", "P", "H", "F"))
}
\arguments{
\item{imageOrientationPatient}{A vector of length six taken from the DICOM
header field \dQuote{ImageOrientationPatient}.}

\item{axial}{Characters that are valid in defining an \sQuote{axial} slice.}

\item{coronal}{Characters that are valid in defining a \sQuote{coronal}
slice.}

\item{sagittal}{Characters that are valid in defining a \sQuote{sagittal}
slice.}
}
\value{
Logical value.
}
\description{
Functions to test the orientation for a single slice.
}
\examples{

x <- readDICOMFile(system.file("dcm/Abdo.dcm", package="oro.dicom"))
iop <- header2matrix(extractHeader(x$hdr, "ImageOrientationPatient", FALSE), 6)
is.axial(iop)
is.coronal(iop)
is.sagittal(iop)

x <- readDICOMFile(system.file("dcm/Spine1.dcm", package="oro.dicom"))
iop <- header2matrix(extractHeader(x$hdr, "ImageOrientationPatient", FALSE), 6)
is.axial(iop)
is.coronal(iop)
is.sagittal(iop)

}
\seealso{
\code{\link{getOrientation}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\keyword{misc}
