% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocm.methods.R
\name{plot.ocm}
\alias{plot.ocm}
\title{Plot method for Continuous Ordinal Fits}
\usage{
\method{plot}{ocm}(
  x,
  plot.only = NULL,
  CIs = c("vcov", "no", "rnd.x.bootstrap", "fix.x.bootstrap", "param.bootstrap"),
  R = 100,
  main_gfun = "g function",
  main_density = "Density function when X=0",
  xlab = "Continuous ordinal scale [v]",
  CIcol = "lightblue",
  individual_plots = F,
  ...
)
}
\arguments{
\item{x}{an object of class \code{ocm}}

\item{plot.only}{either NULL, in which case all plots are displayed, or a value among "gfun", 
"quant_resid", "QQplot" or "smoother", in which case only the requested plot is displayed.}

\item{CIs}{method used for confidence bands for the g function. \code{"vcov"} = Wald [default]; \code{"no"} = no CIS;
\code{"rnd.x.bootstrap"} = random-x bootstrap; \code{"fix.x.bootstrap"} = bootstrap with fixed-x 
resampling; \code{"param.bootstrap"} = parametric bootstrap}

\item{R}{the number of bootstrap replicates. Ignored if CIs=\code{"no"}}

\item{main_gfun}{title of the g function plot. Defauts to ``g function (95\% CIs)''}

\item{main_density}{title of the density function plot. Defauts to ``Density function when X=0''}

\item{xlab}{label of the x axis for the g function and the density plots. Defaults to ``Continuous ordinal scale [v]''}

\item{CIcol}{color of the confidence interval bands. Defaults to ``lightblue''}

\item{individual_plots}{logical. If TRUE, every figure is drawn in a new window. If FALSE (default), 
the first four figures are drawn in a 2-by-2 array.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Draws several summary and diagnostic plots, including the estimated g function, 
the estimated density function of the continuous ordinal score for the null model (no covariates), 
the histogram of the quantile residuals, the normal Q-Q plot and any smoother included in the model.
}
\details{
The estimated g function, quantile residual histogram and normal Q-Q plot of an \code{ocm} 
object are plotted. If smothers are included in the formula, the user has the option to 
plot them in the same graph or separately.
If \code{CIs} is not \code{"no"}, 95\% confidence bands are also plotted.
}
\examples{
fit.overall  <- ocm(overall  ~ cycleno + age + bsa + treatment, data=ANZ0001.sub, scale=c(0,100))
plot(fit.overall, CIs="vcov")
\dontrun{
plot(fit.overall, CIs="rnd.x.bootstrap", R=100)
plot(fit.overall, CIs="fix.x.bootstrap", R=100)
plot(fit.overall, CIs="param.bootstrap", R=100)
}
}
\seealso{
\code{\link{ocm}}
}
\author{
Maurizio Manuguerra, Gillian Heller
}
\concept{plot}
